  /*
   *  Object %name    : parser_atp_crys_sst_utils.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_crys_sst_utils.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "parser_atp_sst_utils.h"
#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "SST_SEP_TST.h"
#include "CRYS_SST.h" 
#include "SST_SEP_ATP_Utils.h"

/************************ Global Data ************************/
    extern DxUint8_t*      GlobalMemBuff;
    extern DxUint8_t*       CurrGlobalMemBuff;
    extern DxByte_t*       TST_Workspace;
    extern DxUint32_t     TST_WorkspaceSizeInBytes ;

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_Utility_Handle
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application 
* of the insertion, generation, reading, deletion, and usage of an AES symmetric key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_PARSER_SST_Utility_Handle(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_DataOpTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_DataOpTestData = (TST_ATP_DataOpTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct);
    }


      /* 5. call QA SEP function */
     /***************************/
    SEP_Error = SEPQA_SST_Utility_Handle();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_Utility_Handle");

End:
     /* 6. Free allocated buffers */
    DX_VOS_MemFree(GlobalMemBuff);

     /* 5. end SEP message and return */
     /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_Utility_Handle_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_Utility_Size
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application 
* of the insertion, generation, reading, deletion, and usage of an AES symmetric key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_Utility_Size(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_DataOpTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_DataOpTestData = (TST_ATP_DataOpTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct);
    }


    /* 5. call QA SEP function */
    /***************************/
    SEP_Error = SEPQA_SST_Utility_Size();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_Utility_Handle");

End:
    /* 6. Free allocated buffers */
    DX_VOS_MemFree(GlobalMemBuff);

    /* 5. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_Utility_Size_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}


